#include "mini.h"
#include <vector>
#include "newmat.h"
#include "newmatap.h"
#include "math.h"

using std::vector;

double dist(const double* p1, const double* p2){
	double result = p1[0]*p2[0] + p1[1]*p2[1] + p1[2]*p2[2];
	return sqrt(result);
};

double Point_Point_Align(const vector<PtPair>& pairs, double *alignfx){
	double error = 0;
	
	// Compute centroids
	double cm[3] = {0,0,0};
	double cd[3] = {0,0,0};
	for(int i=0; i < pairs.size(); i++){
		cm[0] += pairs[i].p1[0];
		cm[1] += pairs[i].p1[1];
		cm[2] += pairs[i].p1[2];
		cd[0] += pairs[i].p2[0];
		cd[1] += pairs[i].p2[1];
		cd[2] += pairs[i].p2[2];
		error += dist(pairs[i].p1, pairs[i].p2);
	}
	error /= (double)pairs.size();
	error = sqrt(error);
	cm[0] /= (double)pairs.size();
	cm[1] /= (double)pairs.size();
	cm[2] /= (double)pairs.size();
	cd[0] /= (double)pairs.size();
	cd[1] /= (double)pairs.size();
	cd[2] /= (double)pairs.size();

	
	//Get centered PtPairs
	double m[pairs.size()][3];
	double d[pairs.size()][3];
	for(int i=0; i <  pairs.size(); i++){
		m[i][0] = pairs[i].p1[0] - cm[0];
		m[i][1] = pairs[i].p1[1] - cm[1];
		m[i][2] = pairs[i].p1[2] - cm[2];
		d[i][0] = pairs[i].p2[0] - cd[0];
		d[i][1] = pairs[i].p2[1] - cd[1];
		d[i][2] = pairs[i].p2[2] - cd[2];
	}
	
	//Fill H matrix
	Matrix H(3,3), R(3,3);
	for(int j = 0; j < 3; j++){
		for(int k = 0; k < 3; k++){
			H(j+1, k+1) = 0.0;	
		}
	}
	for(int i = 0; i < pairs.size(); i++){
		for(int j = 0; j < 3; j++){
			for(int k = 0; k < 3; k++){
				H(j+1, k+1) += m[i][j]*d[i][k];
			}
		}
	}

	Matrix U(3,3);
	DiagonalMatrix Lamda(3);
	Matrix V(3,3);
	// Make SVD
	SVD(H, Lamda, U, V);

	//Get rotation
	R = V*(U.t());
	//printf("R: \n");
	//printf("%lf %lf %lf \n", R(1,1), R(1,2), R(1,3));
	//printf("%lf %lf %lf \n", R(2,1), R(2,2), R(2,3));
	//printf("%lf %lf %lf \n", R(3,1), R(3,2), R(3,3));
	
	// Calculate translation
	double translation[3];
	ColumnVector col_vec(3);
	for(int j = 0; j < 3; j++)
		col_vec(j+1) = cd[j];
	ColumnVector r_time_colVec = ColumnVector(R*col_vec);
	translation[0] = cm[0] - r_time_colVec(1);
	translation[1] = cm[1] - r_time_colVec(2);
	translation[2] = cm[2] - r_time_colVec(3);
	
	//Fill result
	alignfx[0] = R(1,1);
	alignfx[1] = R(1,2);
	alignfx[2] = 0;
	alignfx[2] = R(1,3);
	alignfx[3] = 0;
	alignfx[4] = R(2,1);
	alignfx[5] = R(2,2);
	alignfx[6] = R(2,3);
	alignfx[7] = 0;
	alignfx[8] = R(3,1);
	alignfx[9] = R(3,2);
	alignfx[10] = R(3,3);
	alignfx[11] = 0;
	alignfx[12] = translation[0];
	alignfx[13] = translation[1];
	alignfx[14] = translation[2];
	alignfx[15] = 1;
	return error;
}
